% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{values.DTSg}
\alias{values.DTSg}
\alias{values}
\title{Get Values}
\usage{
\method{values}{DTSg}(x, reference = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{reference}{A logical specifying if a copy of the \emph{values} or a
reference to the \emph{values} is returned. See details for further
information.}

\item{\dots}{Not used (S3 method only).}
}
\value{
Returns a \code{\link[data.table]{data.table}} or a reference to a
 \code{\link[data.table]{data.table}}.
}
\description{
Queries the \emph{values} of a \code{\link{DTSg}} object.
}
\details{
A reference to the \emph{values} of a \code{\link{DTSg}} object can be used
 to modify them in place. This includes the \emph{.dateTime} column, which
 serves as the object's time index. Modifying this column can therefore
 endanger its integrity. In case needs to do so ever arise,
 \code{\link{refresh}} should be called immediately afterwards in order to
 check the object's integrity.
}
\note{
The original name of the \emph{.dateTime} column is restored when not
 returned as a reference.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# get values
## R6 method
x$values()

## S3 method
values(x = x)

}
\seealso{
\code{\link{DTSg}}, \code{\link{refresh}},
 \code{\link[data.table]{data.table}}
}
