% Please edit documentation in R/shiny.R
\name{dataTableProxy}
\alias{addRow}
\alias{clearSearch}
\alias{dataTableProxy}
\alias{reloadData}
\alias{selectCells}
\alias{selectColumns}
\alias{selectPage}
\alias{selectRows}
\alias{updateCaption}
\alias{updateSearch}
\title{Manipulate an existing DataTables instance in a Shiny app}
\usage{
dataTableProxy(outputId, session = shiny::getDefaultReactiveDomain(), 
    deferUntilFlush = TRUE)

selectRows(proxy, selected)

selectColumns(proxy, selected)

selectCells(proxy, selected)

addRow(proxy, data)

clearSearch(proxy)

selectPage(proxy, page)

updateCaption(proxy, caption)

updateSearch(proxy, keywords = list(global = NULL, columns = NULL))

reloadData(proxy, resetPaging = TRUE, clearSelection = c("all", "none", 
    "row", "column", "cell"))
}
\arguments{
\item{outputId}{the id of the table to be manipulated (the same id as the one
you used in \code{\link{dataTableOutput}()})}

\item{session}{the Shiny session object (from the server function of the
Shiny app)}

\item{deferUntilFlush}{whether an action should be carried out right away, or
should be held until after the next time all of the outputs are updated}

\item{proxy}{a proxy object returned by \code{dataTableProxy()}}

\item{selected}{an integer vector of row/column indices, or a matrix of two
columns (row and column indices, respectively) for cell indices; you may
use \code{NULL} to clear existing selections}

\item{data}{a single row of data to be added to the table; it can be a matrix
or data frame of one row, or a vector or list of row data (in the latter
case, please be cautious about the row name: if your table contains row
names, here \code{data} must also contain the row name as the first
element)}

\item{page}{a number indicating the page to select}

\item{caption}{a new table caption (see the \code{caption} argument of
\code{\link{datatable}()})}

\item{keywords}{a list of two components: \code{global} is the global search
keyword of a single character string (ignored if \code{NULL});
\code{columns} is a character vector of the search keywords for all columns
(when the table has one column for the row names, this vector of keywords
should contain one keyword for the row names as well)}

\item{resetPaging}{whether to reset the paging position}

\item{clearSelection}{which existing selections to clear: it can be any
combinations of \code{row}, \code{column}, and \code{cell}, or \code{all}
for all three, or \code{none} to keep current selections (by default, all
selections are cleared after the data is reloaded)}
}
\description{
The function \code{datatableProxy()} creates a proxy object that can be used
to manipulate an existing DataTables instance in a Shiny app, e.g. select
rows/columns, or add rows.
}
\note{
\code{addRow()} only works for client-side tables. If you want to use
  it in a Shiny app, make sure to use \code{renderDataTable(..., server =
  FALSE)}.

\code{reloadData()} only works for tables in the server-side processing
  mode, e.g. tables rendered with \code{renderDataTable(server = TRUE)}. The
  data to be reloaded (i.e. the one you pass to \code{dataTableAjax()}) must
  have exactly the same number of columns as the previous data object in the
  table.
}
\references{
\url{http://rstudio.github.io/DT/shiny.html}
}
