% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funGP.R
\name{funGP}
\alias{funGP}
\title{Function comparison using Gaussian Process and Hypothesis testing}
\usage{
funGP(
  datalist,
  xCol,
  yCol,
  confLevel = 0.95,
  testset,
  limitMemory = TRUE,
  opt_method = "nlminb",
  sampleSize = list(optimSize = 500, bandSize = 5000),
  rngSeed = 1
)
}
\arguments{
\item{datalist}{A list of data sets to compute a function for each of them}

\item{xCol}{A numeric or vector stating the column number of covariates}

\item{yCol}{A numeric value stating the column number of target}

\item{confLevel}{A single value representing the statistical significance level for constructing the band}

\item{testset}{Test points at which the functions will be compared}

\item{limitMemory}{A boolean (True/False) indicating whether to limit the memory use or not. Default is true. If set to true, 5000 datapoints are randomly sampled from each dataset under comparison for inference.}

\item{opt_method}{A string specifying the optimization method to be used for hyperparameter estimation. Current options are: \code{'L-BFGS-B'}, \code{'BFGS'}, and \code{'nlminb'}. Default is set to \code{'nlminb'}.}

\item{sampleSize}{A named list of two integer items: \code{optimSize} and \code{bandSize}, denoting the sample size for each dataset for hyperparameter optimization and confidence band computation, respectively, when \code{limitMemory = TRUE}. Default value is \code{list(optimSize = 500, bandSize = 5000)}.}

\item{rngSeed}{Random seed for sampling data when \code{limitMemory = TRUE}. Default is 1.}
}
\value{
a list containing :
 \itemize{
  \item muDiff - A vector of pointwise difference between the predictions from the two datasets \code{(mu2- mu1)}
  \item mu1 - A vector of test prediction for first data set
  \item mu2 - A vector of test prediction for second data set
  \item band - A vector of the allowed statistical difference between functions at testpoints in testset
  \item confLevel - A numeric representing the statistical significance level for constructing the band
  \item testset - A matrix of test points to compare the functions
  \item estimatedParams - A list of estimated hyperparameters for GP
}
}
\description{
Function comparison using Gaussian Process and Hypothesis testing
}
\examples{

datalist = list(data1[1:100,], data2[1:100, ])
xCol = 2
yCol = 7
confLevel = 0.95
testset = seq(4,10,length.out = 20)
function_diff = funGP(datalist, xCol, yCol, confLevel, testset)

}
\references{
Prakash, A., Tuo, R., & Ding, Y. (2022). "Gaussian process aided function comparison using noisy scattered data," Technometrics, Vol. 64, No. 1, pp. 92-102, \doi{10.1080/00401706.2021.1905073}.
}
