% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header_to_fwf_position.R
\name{header_to_fwf_position}
\alias{header_to_fwf_position}
\title{Converts header line into a vector of column names}
\usage{
header_to_fwf_position(
  header,
  left_justified = "EXCODE",
  col_types = NULL,
  col_names = NULL,
  read_only = NULL
)
}
\arguments{
\item{header}{A length-one character vector of a header line
from a DSSAT format output file}

\item{left_justified}{A character vector of column names that
should be left justified}
}
\value{
a tibble containing the begin position, end position,
 and name for each column from the original header line
}
\description{
Converts header line into a vector of column names
}
\examples{

header_line <-
  "@YEAR DOY   DAS   SRAA    ES1D    ES2D    ES3D    ES4D    ES5D    ES6D    ES7D    ES8D"
DSSAT:::header_to_fwf_position(header_line)
}
\keyword{internal}
