% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_v_fmt.R
\name{add_v_fmt}
\alias{add_v_fmt}
\title{Adds variable format information to a tibble}
\usage{
add_v_fmt(input_tbl, v_fmt = NULL)
}
\arguments{
\item{input_tbl}{a tibble}

\item{v_fmt}{a named vector containing variable format information to be
added to `input_tbl`}
}
\value{
a tibble containing the original tibble with an additional attribute
that contains variable format information
}
\description{
Adds variable format information to a tibble
}
\examples{

# Extract file path for sample ecotype file
sample_eco_file <- system.file('extdata','SAMPLE.ECO',package='DSSAT')

# Read sample ecotype file
eco <- read_eco(sample_eco_file)

# Replace formats for TSEN and CDAY parameters
eco <- add_v_fmt(eco,v_fmt=c(TSEN='\%6.1f',CDAY='\%6.1f'))

}
