% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupDSLiteServer.R
\name{setupDSLiteServer}
\alias{setupDSLiteServer}
\title{Setup an environment based on named datasets and logindata}
\usage{
setupDSLiteServer(
  packages = c(),
  datasets,
  logindata,
  pkgs = NULL,
  dslite.server = NULL,
  env = parent.frame()
)
}
\arguments{
\item{packages}{DataSHIELD server-side packages which local installation must be verified so that the \link{DSLiteServer}
can auto-configure itself and can execute the DataSHIELD operations. Default is none.}

\item{datasets}{Names of the datasets to be loaded using \link{data}.}

\item{logindata}{Name of the login data object to be loaded using \link{data}.}

\item{pkgs}{The package(s) to look in for datasets, default is all, then the 'data' subdirectory (if present)
of the current working directory (same behavior as 'package' argument in \link{data}).}

\item{dslite.server}{Symbol name to which the \link{DSLiteServer} should be assigned to. If not provided, the symbol name
will be the first not null one specified in the 'url' column of the loaded login data.}

\item{env}{The environment where DataSHIELD objects should be looked for: the \link{DSLiteServer} and
the DSIConnection objects. Default is the Global environment.}
}
\value{
The login data for the \link{datashield.login} function.
}
\description{
Load the provided datasets and the corresponding logindata object, instanciate a new \link{DSLiteServer}
hosting these datasets, verifies that the required DataSHIELD server-side packages are installed.
All the data structures are loaded by \link{data} which supports various formats (see data() documentation).
}
\examples{
{
logindata <- setupDSLiteServer(
                 datasets = c("CNSIM1", "CNSIM2", "CNSIM3"),
                 logindata = "logindata.dslite.cnsim", pkgs = "DSLite",
                 dslite.server = "dslite.server")
conns <- datashield.login(logindata, assign=TRUE)
# do DataSHIELD analysis
datashield.logout(conns)
}

}
\seealso{
Other setup functions: 
\code{\link{setupCNSIMTest}()},
\code{\link{setupDASIMTest}()},
\code{\link{setupDATASETTest}()},
\code{\link{setupDISCORDANTTest}()},
\code{\link{setupSURVIVALTest}()}
}
\concept{setup functions}
