% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_SIR_model_ode.R
\name{simulate_SIR_model_ode}
\alias{simulate_SIR_model_ode}
\title{SIR model}
\usage{
simulate_SIR_model_ode(
  S = 1000,
  I = 1,
  R = 0,
  b = 0.002,
  g = 1,
  tstart = 0,
  tfinal = 100,
  dt = 0.1
)
}
\arguments{
\item{S}{: starting value for Susceptible : numeric}

\item{I}{: starting value for Infected : numeric}

\item{R}{: starting value for Recovered : numeric
Values for model parameters : numeric}

\item{b}{: infection rate : numeric}

\item{g}{: recovery rate : numeric
Values for model times : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Time step : numeric}
}
\value{
The function returns the output as a list. 
The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
The \code{ts} dataframe has one column per compartment/variable. The first column is time.
}
\description{
A basic SIR model with 3 compartments and infection and recovery processes
}
\details{
The model includes susceptible, infected, and recovered compartments. The two processes that are modeled are infection and recovery.

This code is was generated by the modelbuilder package R.  
The model is implemented as a set of ordinary differential equations using the deSolve package. 
The following R packages need to be loaded for the function to work: deSolve. 

Starting conditions for model variables
}
\section{Warning}{
 This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
}

\section{Model Author}{
 Andreas Handel
}

\section{Model creation date}{
 2020-09-01
}

\section{Code Author}{
 generated by the \code{modelbuilder} R package
}

\section{Code creation date}{
 2020-09-01
}

\examples{
 
# To run the simulation with default parameters:  
result <- simulate_SIR_model_ode() 
# To choose values other than the standard one, specify them like this:  
result <- simulate_SIR_model_ode(S = 2000,I = 2,R = 0) 
# You can display or further process the result, like this:  
plot(result$ts[,'time'],result$ts[,'S'],xlab='Time',ylab='Numbers',type='l') 
print(paste('Max number of S: ',max(result$ts[,'S']))) 
}
