% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_evolution_stochastic.R
\name{simulate_evolution_stochastic}
\alias{simulate_evolution_stochastic}
\title{Stochastic simulation of a compartmental SIR-type model with wild-type and mutant strains and treatment}
\usage{
simulate_evolution_stochastic(
  S = 1000,
  Iu = 1,
  It = 1,
  Ir = 1,
  bu = 0.001,
  bt = 0.001,
  br = 0.001,
  cu = 0.001,
  ct = 0.01,
  f = 0,
  gu = 1,
  gt = 1,
  gr = 1,
  tmax = 100,
  rngseed = 100
)
}
\arguments{
\item{S}{: initial number of susceptible hosts : numeric}

\item{Iu}{: initial number of wild-type infected untreated hosts : numeric}

\item{It}{: initial number of wild-type infected treated hosts : numeric}

\item{Ir}{: initial number of resistant infected hosts : numeric}

\item{bu}{: level/rate of infectiousness for hosts in the Iu compartment : numeric}

\item{bt}{: level/rate of infectiousness for hosts in the It compartment : numeric}

\item{br}{: level/rate of infectiousness for hosts in the Ir compartment : numeric}

\item{cu}{: fraction of resistant mutant infections that an untreated host produces : numeric}

\item{ct}{: fraction of resistant mutant infections that a treated host produces : numeric}

\item{f}{: fraction of infected receiving treatment : numeric}

\item{gu}{: rate at which a host leaves the Iu compartment : numeric}

\item{gt}{: rate at which a person leaves the It compartment : numeric}

\item{gr}{: rate at which a person leaves the Ir compartment : numeric}

\item{tmax}{: maximum simulation time : numeric}

\item{rngseed}{: seed for random number generator to allow reproducibility : numeric}
}
\value{
This function returns the simulation result as obtained from a call
  to the adaptivetau integrator in list form. The list element ts is a
  dataframe where the first column is "time," and the remaining columns are the variables
}
\description{
Simulation of a stochastic 2-strain SIR model with the following compartments:
Susceptibles (S), Infected with wild-type/sensitive and untreated (Iu),
Infected with wild-type and treated (It), infected with resistant (Ir), 
Recovered and Immune (R). allows exploration of evolutionary dynamics
}
\details{
A compartmental ID model with several states/compartments
is simulated as a stochastic model using the adaptive tau algorithm as implemented by ssa.adaptivetau()
in the adaptivetau package. See the manual of this package for more details.
}
\section{Warning}{

This function does not perform any error checking. So if you try to do
something nonsensical (e.g. have negative values or fractions > 1),
the code will likely abort with an error message
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_evolution_stochastic()
# To choose parameter values other than the standard one, specify them like such:
result <- simulate_evolution_stochastic(S = 2000,  tmax = 200, bt = 0.01)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[ , "time"],result$ts[ , "S"],xlab='Time',ylab='Number Susceptible',type='l')
}
\references{
See the manual for the adaptivetau package for details on the algorithm.
            The implemented model is loosely based on: Handel et al 2009 JTB 
           "Antiviral resistance and the control of pandemic influenza: The roles of
           stochasticity, evolution and model details"
}
\author{
Andreas Handel
}
