% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Disease2SPheatmap.R
\name{Disease2SPheatmap}
\alias{Disease2SPheatmap}
\title{Plot a heat map of the subpathways activity regulated by disease}
\usage{
Disease2SPheatmap(CentralityScore,ExpData,Label,pcut=0.05,bk=c(-2,2),
                  cluster.rows=FALSE,cluster.cols=FALSE,show.rownames=TRUE,
                  show.colnames=FALSE,col=c("navy","firebrick3"),
                  cell.width=NA,cell.height=NA,scale="row",fontsize=7,
                  fontsize.row=9,fontsize.col=10)
}
\arguments{
\item{CentralityScore}{A dataframe with seven columns those are subpath ID, subpathway name, subpathway size, genes in subpathway, centralscore (eigenvector centrality), Pvalue and FDR.}

\item{ExpData}{A gene expression profile of interest.}

\item{Label}{A character vector consist of "0" and "1" which represent sample class in gene expression profile. "0" means normal sample and "1" means disease sample.}

\item{pcut}{A numeric value which represent threshold. Subpathways with p-value less than this threshold will be screened out and visualized.}

\item{bk}{A numeric vector that covers the range of values. Users could adjust color depth through this parameter.}

\item{cluster.rows}{Boolean values determining if rows should be clustered or hclust object.}

\item{cluster.cols}{Boolean values determining if columns should be clustered or hclust object.}

\item{show.rownames}{Boolean specifying if row names are be shown.}

\item{show.colnames}{Boolean specifying if column names are be shown.}

\item{col}{Vector of colors used in heatmap.}

\item{cell.width}{Individual cell width in points. If left as NA, then the values depend on the size of plotting window.}

\item{cell.height}{Individual cell height in points. If left as NA, then the values depend on the size of plotting window.}

\item{scale}{Character indicating if the values should be centered and scaled in either the row direction or the column direction, or none. Corresponding values are "row", "column" and "none".}

\item{fontsize}{Base fontsize for the plot (default: 10).}

\item{fontsize.row}{Fontsize for rownames (default: 10).}

\item{fontsize.col}{Fontsize for colnames (default: 10).}
}
\value{
A heat map
}
\description{
The "Disease2SPheatmap" function plots a heat map of the subpathways that are regulated by disease.  We map subpathways to the disease gene expression through ssgsea to get a subpathway abundance matrix. Then we visualize the matrix by heatmap.
}
\examples{
#Load depend package
library(GSVA)
library(pheatmap)
#Obtain input data (The "CentralityScoreResult" is the result of function "CalCentralityScore")
GEP<-GetExample('GEP')
Slabel<-GetExample('Slabel')
CentralityScoreResult<-GetExample('CentralityScoreResult')
#Run the function
#Disease2SPheatmap(CentralityScore=CentralityScoreResult,ExpData=GEP,Label=Slabel,
#                  pcut=0.05,bk=c(-2,2),cluster.rows=FALSE,cluster.cols=FALSE,
#                  show.rownames=TRUE,show.colnames=FALSE,col=c("navy","firebrick3"),
#                  cell.width=NA,cell.height=NA,scale="row",fontsize=7,
#                  fontsize.row=9,fontsize.col=10)
}
