% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelativeProbabilityNetwork.R
\name{RelativeProbabilityNetwork}
\alias{RelativeProbabilityNetwork}
\title{Computes the probability of observing a type of event in a linear network at a set of points provided}
\usage{
RelativeProbabilityNetwork(X, W, sigma, x, y, mark, category_mark)
}
\arguments{
\item{X}{- A \code{lpp} object representing a marked point pattern lying on a road network (\code{linnet} object)}

\item{W}{- A \code{listw} object representing the neighbourhood structure that the road segments of the network form}

\item{sigma}{- A numeric value representing the bandwidth parameter (in meters)}

\item{x}{- A numeric vector representing the x-coordinates of the points of the network at which the relative probability is computed}

\item{y}{- A numeric vector representing the y-coordinates of the points of the network at which the relative probability is computed}

\item{mark}{- Mark of \code{X} that is used to characterize the type of event. The algorithm searches microzones of the network where this mark is over- or underrepresented}

\item{category_mark}{- A numeric/character value from the set allowed in the chosen \code{mark} to compute the relative probability in relation to it}
}
\value{
Returns a list of length equal to \code{length(x)}. Each component of the list is itself a list, containing two numeric vectors. Given an index \code{i}, the first vector provides the relative probability of the event type being considered at the point of coordinates \code{x[i]} and \code{y[i]}, the number of events of the type of interest found at \code{sigma} meters from the point of coordinates \code{x[i]} and \code{y[i]}, and the total number of events found at \code{sigma} meters from this point (regardless of the type). The second vector contains the indexes (according to object \code{X}) of all the events used for the estimation of the corresponding relative probability, at \code{sigma} meters of distance (regardless of the type)
}
\description{
Given a marked point pattern lying on a linear network structure, this function uses kernel density estimation (KDE) to estimate a probability of occurrence for a type of event specified by the user through the marks of the pattern at the points of the network provided. The marks of a point pattern represent additional information of the events that are part of the pattern
}
\examples{
library(DRHotNet)
library(spatstat)
library(spdep)
library(raster)
library(maptools)
\donttest{
network=SampleMarkedPattern$domain
X=SampleMarkedPattern
network_lix=lixellate(network,eps=50)
X_lix=lpp(cbind(X$data$x,X$data$y),network_lix)
marks(X_lix)=marks(X)
sigma=100
collision_type="Rear-end"
W=NeighbourhoodMatrixNetwork(network_lix)
projection="+proj=utm +zone=30 ellps=WGS84 +ellps=WGS84"
network_lix_sp=as.SpatialLines.psp(as.psp(network_lix))
proj4string(network_lix_sp)=projection
middle_points=SpatialLinesMidPoints(network_lix_sp)@coords
x=middle_points[,1]
y=middle_points[,2]
relative_probabilities=RelativeProbabilityNetwork(X_lix,W,sigma,x,y, 
                       "Collision",collision_type)
}
}
\references{
Baddeley, A., Rubak, E., & Turner, R. (2015). Spatial point patterns: methodology and applications with R. Chapman and Hall/CRC.

Diggle, P. J. (2013). Statistical analysis of spatial and spatio-temporal point patterns. Chapman and Hall/CRC.

Kelsall, J. E., & Diggle, P. J. (1995). Kernel estimation of relative risk. Bernoulli, 1(1-2), 3-16.

McSwiggan, G., Baddeley, A., & Nair, G. (2017). Kernel density estimation on a linear network. Scandinavian Journal of Statistics, 44(2), 324-345.
}
