% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_user_data_fxns.R
\name{runDRAFT}
\alias{runDRAFT}
\title{Main driver for using \code{DRAFT} to fit user provided incidence data.}
\usage{
runDRAFT(inc_data = NULL, out_dir = NULL, pop = 10000,
  epi_model = 1, Tg = 3, sigma = NULL, dp = NULL, dq = NULL,
  ts = NULL, dL = NULL, nMCMC = 10000, verbose = TRUE)
}
\arguments{
\item{inc_data}{Dataframe containing incidence data.  Must contain 'date' and 'cases' columns.  The 'date' column must either be Date-class or convert to Date-class using as.Date(inc_data$date, format="\%Y-\%m-\%d").}

\item{out_dir}{Character string containing file path for output images and data files.  If not specified, DRAFT will not generate output images or files.}

\item{pop}{Integer population of the region for which incidence is provided}

\item{epi_model}{- integer 1 (SIR), 2 (SEIR), 3 (SIR with behavior terms). Default is 1-SIR.}

\item{Tg}{Numeric, generation time in days. Default is 3 days}

\item{sigma}{inverse of of the latent period in days. Needed only for an SEIR model. Default NULL}

\item{dp}{Proporiton of susceptible contact rate (0-1) following behavior modification. For example: If susceptibles reduce their contacts by 25\%, set \code{dp=0.75}.  Only used if inc_data requires a forecast.}

\item{dq}{Proportion of infectious contact rate (0-1) following behavior modification.  If infectious cases reduce their contacts by one half, set \code{dq=0.5}.  Only used if inc_data requires a forecast.}

\item{ts}{Date class.  Start date of behavior modification.}

\item{dL}{Number of days for behavior modification to completely take effect.}

\item{nMCMC}{Number of steps to take in the Markov Chain Monte Carlo (MCMC) process.  Number of steps needed for a good 'fit' will vary from case-to-case, but should never be less than 1e3.  It is recommended to start at 1e4 and increase as needed.}

\item{verbose}{This logical flag determines if code updates are printed to console/STDOUT during execution.  It is recommended that verbose be set to TRUE for longer runs so the user may monitor progress.}
}
\value{
A list with the input and entire output of the run.  List entries:
  \itemize{
    \item \emph{mydata}: A data structure containing the input data.
    \item \emph{rtn}: The best-fit profile.
    \item \emph{profile}: The full MCMC distribution of incidence profiles as a matrix. 
    \item \emph{tab}: The full MCMC distribution of parameters as a matrix.
  }
  Additional output is written to a subdirectory 'user_data_*' within the current working directory.  File list:
  \itemize{
    \item \emph{results-user_data-*.png}: This image shows the fit relative to the data as well as critical-parameter distributions. 
    \item \emph{user_data-incidence.png}: Incidence data plot.
    \item \emph{mcmc-user_data-*.RData}: A list that includes the resulting MCMC parameter distributions.
    \item \emph{profiles-user_data-*.RData}: A list that includes resulting distribution of incidence profiles.
  }
}
\description{
\code{runDRAFT} accepts a user provided incidence dataframe and uses that along with the user provided population and generation time, Tg, (and if relevant the latent period sigma) to fit the incidence data.  Additionally, when specified by the user, \code{runDRAFT} will also generate a forecast for the incidence.
Data cadence is arbitrary but at most can be monthly.
We support S-I-R and S-E-I-R models for a single population with a fixed (non-time-dependent) force of infection.
}
\details{
Data fitting is done using a Markov Chain Monte Carlo (MCMC) procedure.  While generally discussed in the context of optimization, this procedure results in a mapping of the objective distribution.  Thus the results of runDRAFT() come in the form of a distribution of parameters and the resulting distribution of incidence profiles.
}
\examples{
# See examples vignette for a more in-depth walkthrough.
library(DRAFT)
vignette("DRAFT_examples")
# Run an SEIR model using the incidence file and assuming a 
# population of 1 million people.
# The generation time and latent period are set to 2.6 days 
# and 3 days respectively
head(incidence_data2)
temp_write = tempdir()
\donttest{output <- runDRAFT(inc_data=incidence_data2, out_dir=temp_write,
 pop = 1e6, epi_model = 2, Tg = 2.6, sigma = 3.)}
\dontshow{output <- runDRAFT(inc_data=incidence_data2, out_dir=NULL,
 pop = 1e6, epi_model = 2, Tg = 2.6, sigma = 3., nMCMC=200)}

# Run an SIR model using the incidence file and assuming a 
# population of 10,000 people.
# The generation time is set to 3 days. (No need to define 
# a latent period.)
head(incidence_data1)
\donttest{output <- runDRAFT(inc_data=incidence_data2, out_dir=temp_write,
 pop = 1e5, epi_model = 1, Tg = 3.)}
\dontshow{output <- runDRAFT(inc_data=incidence_data2, out_dir=NULL,
 pop = 1e5, epi_model = 1, Tg = 3., nMCMC=200)}

}
