% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatModels.R
\name{generate.loss.gr.huber}
\alias{generate.loss.gr.huber}
\title{Generator for Huber Loss Function Gradient}
\usage{
generate.loss.gr.huber(h)
}
\arguments{
\item{h}{Positive real number for the Huber loss parameter. Lower values more
closely approximate hinge loss. Higher values produce smoother Huber loss
functions.}
}
\value{
Huber loss function gradient with parameter h in the form required by
\code{\link{EmpiricalRiskMinimizationDP.CMS}}.
}
\description{
This function generates and returns the Huber loss function gradient used for
privacy-preserving SVM at the specified value of h in the form required by
\code{\link{EmpiricalRiskMinimizationDP.CMS}}.
}
\examples{
  h <- 1
  huber <- generate.loss.gr.huber(h)
  y.hat <- c(-.5, 1.2, -0.9)
  y <- c(-1, 1, -1)
  huber(y.hat,y)
  huber(y.hat, y, w=c(0.1, 0.5, 1)) # Weights observation-level loss gradient

}
\keyword{internal}
