% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mechanisms.R
\name{ExponentialMechanism}
\alias{ExponentialMechanism}
\title{Exponential Mechanism}
\usage{
ExponentialMechanism(
  utility,
  eps,
  sensitivity,
  measure = NULL,
  candidates = NULL
)
}
\arguments{
\item{utility}{Numeric vector giving the utilities of the possible values.}

\item{eps}{Positive real number defining the epsilon privacy budget.}

\item{sensitivity}{Real number corresponding to the l1-global sensitivity of
the function generating utility.}

\item{measure}{Optional numeric vector of scaling measures for the
probabilities of selecting each value. Should be same size as utility.
Defaults to uniform scaling.}

\item{candidates}{Optional vector of candidates of same size as utility. If
given, the function returns the candidate at the selected index rather than
the index itself.}
}
\value{
Indices (or values if candidates given) selected by the mechanism
based on the bounded and/or unbounded definitions of differential privacy.
}
\description{
This function implements the exponential mechanism for differential privacy
by selecting the index of a vector of candidates to return according to a
user-specified vector of utility function values, epsilon, and global
sensitivity. Sensitivity calculated based either on bounded or unbounded
differential privacy can be used \insertCite{Kifer2011}{DPpack}. If measure
is provided, the probabilities of selecting each value are scaled according
to the values in measure. If candidates is provided, the function returns the
value of candidates at the selected index, rather than the index itself.
}
\examples{
candidates <- c('a','b','c','d','e','f','g')
# Release index
idx <- ExponentialMechanism(c(0,1,2,3,2,1,0), 1, 1)
candidates[idx] # Randomly chosen candidate

# Release candidate
ExponentialMechanism(c(0,1,2,3,2,1,0), 1, .5, measure=c(1,1,2,1,2,1,1),
  candidates=candidates)

}
\references{
\insertRef{Dwork2006a}{DPpack}

\insertRef{Kifer2011}{DPpack}

\insertRef{McSherry2007}{DPpack}
}
