% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ndNMF.R
\name{ndNMF}
\alias{ndNMF}
\title{a new discriminant Non-Negative Matrix Factorization (dNMF)}
\usage{
ndNMF(dat, trainlabel, r = 2, lambada = 0.1, maxIter = 1000,
  tol = 1e-07, log = TRUE, plotit = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{dat}{a matrix with gene in row and sample in column}

\item{trainlabel}{the label of sample, like c(1,1,2,2,2)}

\item{r}{the dimension of expected reduction dimension, with the default value 2}

\item{lambada}{a relative weighting factor for the discriminant. Default 0.1}

\item{maxIter}{the maximum iteration of update rules, with the default value 1000}

\item{tol}{the toleration of coverange, with the default value 1e-7}

\item{log}{log2 data. Default is TRUE.}

\item{plotit}{whether plot H (V=WH). Default: FALSE.}

\item{verbose}{TRUE}

\item{...}{to gplots::heatmap.2}
}
\description{
The ndNMF algorithm with the additional Fisher criterion on the cost
 function of conventional NMF was designed to increase class-related
 discriminating power.
}
\details{
This algorithm is based on articles.
 \enumerate{
 \item Kim, Bo-Kyeong, and Soo-Young Lee. "Spectral Feature Extraction Using dNMF for Emotion Recognition in Vowel Sounds." Neural Information Processing. Springer Berlin Heidelberg, 2013.
 \item Lee, Soo-Young, Hyun-Ah Song, and Shun-ichi Amari. "A new discriminant NMF algorithm and its application to the extraction of subtle emotional differences in speech." Cognitive neurodynamics 6.6 (2012): 525-535.
 }
}
\examples{
dat <- rbind(matrix(c(rep(3, 16), rep(8, 24)), ncol=5),
matrix(c(rep(5, 16), rep(5, 24)), ncol=5),
matrix(c(rep(18, 16), rep(7, 24)), ncol=5)) +
matrix(runif(120,-1,1), ncol=5)
trainlabel <- c(1,1,2,2,2)

res <- ndNMF(dat, trainlabel, r=2, lambada = 0.1)
res$H
res$rnk
}
\author{
Zhilong Jia and Xiang Zhang
}

