% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dmcobs}
\alias{plot.dmcobs}
\title{plot.dmcobs: Plot combined observed data}
\usage{
\method{plot}{dmcobs}(
  x,
  figType = "all",
  subject = NULL,
  labels = c("Compatible", "Incompatible"),
  cols = c("black", "gray"),
  ltys = c(1, 1),
  pchs = c(1, 1),
  errorBars = FALSE,
  errorBarType = "sd",
  ylimRt = NULL,
  ylimErr = NULL,
  xlimCDF = NULL,
  ylimCAF = NULL,
  cafBinLabels = FALSE,
  ylimDelta = NULL,
  xlimDelta = NULL,
  xlabs = TRUE,
  ylabs = TRUE,
  xaxts = TRUE,
  yaxts = TRUE,
  xylabPos = 2,
  resetPar = TRUE,
  legend = TRUE,
  legend.parameters = list(),
  ...
)
}
\arguments{
\item{x}{Output from dmcObservedData}

\item{figType}{rtCorrect, errorRate, rtErrors, cdf, caf, delta, deltaErrors, deltaER, all}

\item{subject}{NULL (aggregated data across all subjects) or integer for subject number}

\item{labels}{Condition labels c("Compatible", "Incompatible") default}

\item{cols}{Condition colours c("green", "red") default}

\item{ltys}{Linetype see par}

\item{pchs}{Symbols see par}

\item{errorBars}{TRUE(default)/FALSE Plot errorbars}

\item{errorBarType}{sd(default), or se}

\item{ylimRt}{ylimit for Rt plots}

\item{ylimErr}{ylimit for error rate plots}

\item{xlimCDF}{xlimit for CDF plot}

\item{ylimCAF}{ylimit for CAF plot}

\item{cafBinLabels}{TRUE/FALSE}

\item{ylimDelta}{ylimit for delta plot}

\item{xlimDelta}{xlimit for delta plot}

\item{xlabs}{TRUE/FALSE}

\item{ylabs}{TRUE/FALSE}

\item{xaxts}{TRUE/FALSE}

\item{yaxts}{TRUE/FALSE}

\item{xylabPos}{2}

\item{resetPar}{TRUE/FALSE Reset graphical parameters}

\item{legend}{TRUE/FALSE}

\item{legend.parameters}{list}

\item{...}{additional plot pars}
}
\value{
Plot (no return value)
}
\description{
Plot delta results from the output of dmcObservedData. The plot
can be an overall rtCorrect, errorRate, rtErrors, cdf, caf, delta, deltaErrors, deltaER, or all
of the previous plots.
}
\examples{
\donttest{
# Example 1
dat <- dmcCombineObservedData(flankerData, simonData)  # combine flanker/simon data
plot(dat, figType = "all", xlimDelta = c(200, 700), ylimDelta = c(-20, 80),
     cols = c("black", "darkgrey"), pchs = c(1, 2))
plot(dat, figType = "delta", xlimDelta = c(200, 700), ylimDelta = c(-20, 80),
     cols = c("black", "darkgrey"), pchs = c(1, 2), legend = TRUE,
     legend.parameters=list(x="topright", legend=c("Flanker", "Simon")))
}
}
