% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DMCfun.R
\docType{package}
\name{DMCfun-package}
\alias{DMCfun}
\alias{DMCfun-package}
\title{DMCfun: Diffusion Model of Conflict (DMC) in Reaction Time Tasks}
\description{
DMC model simulation detailed in Ulrich, R., Schroeter, H., Leuthold, H., & Birngruber, T. (2015).
  Automatic and controlled stimulus processing in conflict tasks: Superimposed diffusion processes and delta functions.
  Cognitive Psychology, 78, 148-174. Ulrich et al. (2015) <doi:10.1016/j.cogpsych.2015.02.005>.
  Decision processes within choice reaction-time (CRT) tasks are often modelled using evidence accumulation models (EAMs),
  a variation of which is the Diffusion Decision Model (DDM, for a review, see Ratcliff & McKoon, 2008).
  Ulrich et al. (2015) introduced a Diffusion Model for Conflict tasks (DMC). The DMC model combines common
  features from within standard diffusion models with the addition of superimposed controlled and automatic activation.
  The DMC model is used to explain distributional reaction time (and error rate) patterns in common behavioural
  conflict-like tasks (e.g., Flanker task, Simon task). This R-package implements the DMC model and provides functionality
  to fit the model to observed data.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/igmmgi/DMCfun}
  \item \url{https://CRAN.R-project.org/package=DMCfun}
}

}
\author{
\strong{Maintainer}: Ian G. Mackenzie \email{ian.mackenzie@uni-tuebingen.de}

Authors:
\itemize{
  \item Carolin Dudschig \email{carolin.dudschig@uni-tuebingen.de}
}

}
\keyword{internal}
