% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dmclist}
\alias{plot.dmclist}
\title{plot.dmclist: Plot delta plots from multiple dmc simulations.}
\usage{
\method{plot}{dmclist}(
  x,
  ylim = c(-50, 150),
  xlim = NULL,
  col = c("black", "lightgrey"),
  lineType = "l",
  legendPos = "topleft",
  ncol = 1,
  ...
)
}
\arguments{
\item{x}{Output from dmcSims}

\item{ylim}{ylimit for delta plot}

\item{xlim}{xlimit for delta plot}

\item{col}{# color range start/end color}

\item{lineType}{line type ("l", "b", "o") for delta plot}

\item{legendPos}{legend position}

\item{ncol}{number of legend columns}

\item{...}{pars for legend}
}
\description{
Plot delta function from multiple dmc simulations (i.e., dmcSims).
}
\examples{
\donttest{
# Example 1
params <- list(amp = seq(20, 30, 2))
dmc <- dmcSims(params)
plot(dmc, ncol = 2, xlim = c(0, 1300), ylim = c(-100, 200))

# Example 2
params <- list(amp=c(10, 20), tau = seq(20, 80, 40), drc = seq(0.2, 0.6, 0.2), nTrl = 50000)
dmc <- dmcSims(params)
plot(dmc, ncol = 2, col=c("green", "blue"), lineType = "l")

}

}
