% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineClasses.r
\docType{class}
\name{Imp-class}
\alias{Imp-class}
\title{Class \code{'Imp'}}
\description{
An operating model component that specifies the degree of adherence to management recommendations (Implementation error)
}
\section{Slots}{

\describe{
\item{\code{Name}}{The name of the Implementation error object}

\item{\code{TACSD}}{lognormal standard deviation in fraction of TAC taken (uniform distribution)}

\item{\code{TACFrac}}{Mean fraction of TAC taken (uniform distribution) (can be an improper fraction greater than 1)}

\item{\code{ESD}}{lognormal standard deviation in fraction of TAE taken(uniform distribution)}

\item{\code{EFrac}}{Mean fraction of recommended effort taken (uniform distribution)}

\item{\code{SizeLimSD}}{lognormal error in size limit implementation (uniform distribution)}

\item{\code{SizeLimFrac}}{Mean fraction of the size limit (uniform distribution) (can be an improper fraction greater than 1)}

\item{\code{DiscMort}}{Discard mortality rate (uniform distribution) (can be an improper fraction greater than 1)}

\item{\code{Source}}{A reference to a website or article form which parameters were taken to define the operating model}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new('Imp')}
}

\examples{

showClass('Imp')

}
\author{
T. Carruthers
}
\keyword{classes}
