% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rep2.R
\name{rep2}
\alias{rep2}
\title{Repeat something with the ability to also collapse the output.}
\usage{
rep2(x, n, ...)
}
\arguments{
\item{x}{The object to repeat}

\item{n}{The amount how often the object should be repeated}

\item{...}{Further arguments passed to `paste` (see `help("paste")` for
more information).}
}
\value{
The result from
  `paste(rep(x, n), sep = sep, collapse = collapse)`
}
\description{
Repeat something with the ability to also collapse the output.
  The base `rep("ha", 3)` function does not support arguments like
  `collapse` or `sep` like `paste(...)`. `rep2` closes this gap.
}
\examples{
  ## rep2 is the same like rep:
  rep(x = "ha", 3)
  #> "ha" "ha" "ha"
  DIZutils::rep2(x = "ha", 3)
  #> "ha" "ha" "ha"

  ## ... but you can also use the arguments from `paste`:
  DIZutils::rep2(x = "ha", n = 3, collapse = "")
  #> "hahaha"

}
