% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_diff_print.R
\name{time_diff_print}
\alias{time_diff_print}
\title{Calculate time difference of two timestamps, round the value and
  return a string with suiting unit.}
\usage{
time_diff_print(
  older_timestamp,
  newer_timestamp = NULL,
  iteration = NULL,
  iterations = NULL,
  remaining_time = TRUE,
  eta = TRUE,
  prefix_iteration = "Iteration ",
  prefix_time_elapsed = "Time elapsed: ",
  prefix_time_remaining = "Remaining: ",
  prefix_eta = "ETA: ",
  digits = 2,
  thousands_separator = "",
  decimal_separator = "."
)
}
\arguments{
\item{older_timestamp}{(POSIXct) Start time.}

\item{newer_timestamp}{(POSIXct, Optional) End time. If not set, the current
time will be used.}

\item{iteration}{(Numeric, Optional) The current iteration if also the time
process within all iterations additional to the elapsed time is of
interest.}

\item{iterations}{(Numeric, Optional) The total number of iterations.}

\item{remaining_time}{(Boolean, Optional, Default = TRUE) Should the
estimated time needed to finish all iterations be displayed?}

\item{eta}{(Boolean, Optional, Default = TRUE) Should the
estimated time of arrival needed to finish all iterations be displayed?}

\item{prefix_iteration, prefix_time_elapsed, prefix_time_remaining, prefix_eta}{Prefixes for the output string.}

\item{digits}{(int, optional) The number of digits after the decimal
separator to round to.}

\item{thousands_separator}{(string, optional) Used as mark between every 3
decimals before the decimal point.}

\item{decimal_separator}{(string, optional) The character to be used to
indicate the numeric decimal point.}
}
\value{
A list with one element per row of the input file
}
\description{
Create string with time difference in suitable unit.
  Additional automatically add the remaining time depending on the position
  in an iteration process, or the estimated time of arrival by just
  providing the current and total iteration step(s).
}
\examples{
## Since no second timestamp is provided, the current time
## (currently 2023-03-08) will be assumed:
DIZtools::time_diff_print("2023-01-01 10:00")
#> [1] "Time elapsed: 66.20 days"
DIZtools::time_diff_print("2023-01-01 10:00", iteration = 7, iterations = 10)
#> [1] "Iteration 7 of 10 (70.00 \%), Time elapsed: 66.20 days
#>     (Remaining: ~ 28.37 days, ETA: ~ 05. Apr 2023 - 23:42 UTC)"
}
