% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testsResiduals.R
\name{testSpatialAutocorrelation}
\alias{testSpatialAutocorrelation}
\title{Test for spatial autocorrelation}
\usage{
testSpatialAutocorrelation(simulationOutput, x = NULL, y = NULL,
  distMat = NULL, plot = T)
}
\arguments{
\item{simulationOutput}{a DHARMa object with simulated residuals created with \code{\link{simulateResiduals}}}

\item{x}{the x coordinate, in the same order as the data points. If not provided, random values will be created}

\item{y}{the x coordinate, in the same order as the data points. If not provided, random values will be created}

\item{distMat}{optional distance matrix. If not provided, a distance matrix will be calculated based on x and y. See details for explanation}

\item{plot}{whether to plot output}
}
\description{
This function performs a standard test for spatial autocorrelation on the simulated residuals
}
\details{
The function performs Moran.I test from the package ape, based on the provided distance matrix of the data points. 

There are several ways to specify this distance. If a distance matrix (distMat) is provided, calculations will be based on this distance matrix, and x,y coordinates will only used for the plotting (if provided)
If distMat is not provided, the function will calculate the euclidian distances between x,y coordinates, and test Moran.I based on these distances.

The sense of being able to run the test with x/y = NULL (random values) is to test the rate of false positives under the current residual structure (random x/y corresponds to H0: no spatial autocorrelation), e.g. to check if the test has noninal error rates for particular residual structures.
}
\examples{
testData = createData(sampleSize = 40, family = gaussian())
fittedModel <- lm(observedResponse ~ Environment1, data = testData)
res = simulateResiduals(fittedModel)

# Standard use
testSpatialAutocorrelation(res, x =  testData$x, y = testData$y)

# If x and y is not provided, random values will be created
testSpatialAutocorrelation(res)

# Alternatively, one can provide a distance matrix
dM = as.matrix(dist(cbind(testData$x, testData$y)))
testSpatialAutocorrelation(res, distMat = dM)
}
\seealso{
\code{\link{testUniformity}}, \code{\link{testZeroInflation}}, \code{\link{testTemporalAutocorrelation}}, \code{\link{testSimulatedResiduals}}, \code{\link{testOverdispersion}}, \code{\link{testOverdispersionParametric}}
}
