% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_CMP_methods.R
\name{predict.glm_CMP}
\alias{predict.glm_CMP}
\title{Predict Method for glm_CMP Fits}
\usage{
\method{predict}{glm_CMP}(object, newdata = NULL, type = c("link", "response"), ...)
}
\arguments{
\item{object}{a fitted object of class inheriting from \code{"glm_CMP"}.}

\item{newdata}{optionally, a data frame in which to look for variables with
which to predict. If omitted, the fitted linear predictors are used.}

\item{type}{the type of prediction required. The default is on the scale of
the linear predictors; the alternative \code{"response"} is on the scale of
the response variable.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector with the prediction means.
}
\description{
Obtains predictions from a fitted \code{glm_CMP} object.
}
\examples{
## Fit a model
Bids$size.sq <- Bids$size ^ 2
fit <- glm.CMP(formula.mu = numbids ~ leglrest + rearest + finrest +
               whtknght + bidprem + insthold + size + size.sq + regulatn,
               formula.nu = numbids ~ 1, data = Bids)

## As the newdata parameter is not used the fitted values are obtained
predict(fit, type = "response")
}
