% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals}
\alias{residuals}
\alias{residuals.glm_hP}
\alias{residuals.glm_CMP}
\title{Extract and Visualize hyper-Poisson and COM-Poisson Model Residuals}
\usage{
\method{residuals}{glm_hP}(
  object,
  type = c("pearson", "response", "quantile"),
  envelope = FALSE,
  rep = 19,
  title = "Simulated Envelope of Residuals",
  ...
)

\method{residuals}{glm_CMP}(
  object,
  type = c("pearson", "response", "quantile"),
  envelope = FALSE,
  rep = 19,
  title = "Simulated Envelope of Residuals",
  ...
)
}
\arguments{
\item{object}{an object of class \code{"glm_hP"} or \code{"glm_CMP"},
typically the result of a call to \code{\link{glm.hP}} or
\code{\link{glm.CMP}}.}

\item{type}{the type of residuals which should be returned. The alternatives
are: "pearson" (default), "response" and "quantile". Can be abbreviated.}

\item{envelope}{a logical value indicating whether the envelope should be
computed.}

\item{rep}{number of replications for envelope construction. Default is 19,
that is the smallest 95 percent band that can be built.}

\item{title}{a string indicating the main title of the envelope.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Residual values.
}
\description{
residuals is a method which extracts model residuals from a \code{"glm_hP"}
or \code{"glm_CMP"} object, commonly returned by \code{\link{glm.hP}} or
\code{\link{glm.CMP}}. Optionally, it produces a half normal plot with a
simulated envelope of the residuals.
}
\details{
The response residuals (\eqn{r_i=y_i - \mu_i}{r[i]=y[i] - \mu[i]}), Pearson
residuals (\eqn{r^P_i = r_i/\sigma_i}{r[i]^P = r[i]/\sigma[i]}) or randomized
quantile residuals are computed. The randomized quantile residuals are
obtained computing the cumulative probabilities that the fitted model being
less than \emph{y} and less or equal than \emph{y}. A random value from a
uniform distribution between both probabilities is generated and the value of
the residual is the standard normal variate with the same cumulative
probability. Four replications of the quantile residuals are recommended
because of the random component (see Dunn and Smyth, 1996 for more details).

The functions \code{\link{plot.glm_hP}} and \code{\link{plot.glm_CMP}}
generate a residuals against fitted values plot and a Normal Q-Q plot.

The Normal Q-Q plot may show an unsatisfactory pattern of the Pearson
residuals of a fitted model: then we are led to think that the model is
incorrectly specified.
The half normal plot with simulated envelope indicates that, under the
distribution of the response variable, the model is fine when only a few
points fall off the envelope.
}
\examples{
## Estimate a hyper-Poisson model
Bids$size.sq <- Bids$size ^ 2
hP.fit <- glm.hP(formula.mu = numbids ~ leglrest + rearest + finrest +
              whtknght + bidprem + insthold + size + size.sq + regulatn,
              formula.gamma = numbids ~ 1, data = Bids)

## Compute residuals

r <- residuals(hP.fit)
## Estimate a COM-Poisson model

Bids$size.sq <- Bids$size ^ 2
CMP.fit <- glm.CMP(formula.mu = numbids ~ leglrest + rearest + finrest +
              whtknght + bidprem + insthold + size + size.sq + regulatn,
              formula.nu = numbids ~ 1, data = Bids)

## Compute its residuals

r <- residuals(CMP.fit)
}
\references{
Peter K. Dunn and Gordon K. Smyth (1996). "Randomized quantile
 residuals". Journal of Computational and Graphical Statistics, 5(3), pp.
 236-244.

 A. C. Atkinson (1981). "Two graphical displays for outlying and influential
 observations in regression". Biometrika, 68(1), pp. 13–20.
}
\seealso{
\code{\link{plots}}
}
