% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/One-Way-ANOVA-Test.R
\name{perform_anova}
\alias{perform_anova}
\title{Function for ANOVA One-Way Test}
\usage{
perform_anova(datafile, con, exp, alpha = 0.05)
}
\arguments{
\item{datafile}{A matrix containing the gene expression data}

\item{con}{A data frame or matrix containing the expression values for the control.}

\item{exp}{A data frame or matrix containing the expression values for the experiment.}

\item{alpha}{Value of significance level ranging from 0 to 1 (default = 0.05 states 5 \% significance).}
}
\value{
A data frame containing values for statistic score, p-values etc for each gene being tested.
}
\description{
Function for ANOVA One-Way Test
}
\examples{
library(DGEAR)
data("gene_exp_data")
data = read_and_preprocess_data(datafile = gene_exp_data, con1=1,con2=10,exp1=11,exp2=20)
perform_anova(datafile = data$datafile, con= data$con, exp= data$exp)
}
