% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{prep_dds_from_data}
\alias{prep_dds_from_data}
\title{Prepare a DESeq2 object based on count and target data.}
\usage{
prep_dds_from_data(count_input, target_input, experiment_design,
  collapseReps = FALSE, rep_field_vector = "Replicate",
  stabilization = "rld")
}
\arguments{
\item{count_input}{Count data in dataframe format as read with prep_counts().  Column names must correspond to target rownames.}

\item{target_input}{Target data in dataframe format as read with prep_targets().  Row names must correspond to count column names.}

\item{experiment_design}{Experimental design for DE comparison.  Can include multiple factors.  Design factors should correspond to column names
in the provided targets file.  Include the primary factor as the final factor in the design and any secondary or batch effects prior.
Must be prefaced with a tilde (~).   I.E. ~ Batch1 + Batch2 + SecondaryCondition + PrimaryCondition}

\item{collapseReps}{Boolean. Collapse technical replicates. Default: False}

\item{rep_field_vector}{Target metadata column identifying which samples correspond to which replicates
and maps samples to their replicate identifiers.  Required if collapseReps is TRUE.}

\item{stabilization}{Method of normalizing transformation to perform.  Possible values are "rld" and "vst".  rld will execute
DESeq2's rlog transformation, whereas vst will apply variance stabilizing transformation to the data.  For larger data sets
vst is recommended.}
}
\value{
This function will return a properly formatted DESeq2 object based on the provided normalization method and experimental design.
}
\description{
This function takes count and targets data and creates a DESeq2 object based on the provided design.
}
\examples{
\dontrun{

/*
 * Create a DESeq2 data object using previously read count and target data.
 * Differential expression groups indicated by "Infection" column of target data.
 * Apply a rlog transformation to the data. TMM normalization applied.
 */
dds <- prep_dds_from_data(count_input=myCounts, target_input=myTargets,
                           experiment_design= ~ Infection, stabilization="rld")


/*
 * Create a DESeq2 data object using previously read count and target data.
 * Differential expression groups indicated by "Infection" column of target data.
 * Takes into account a batch effect column of target data.
 * Apply a variance stabilizing transformation to the data. TMM normalization applied.
 */
dds <- prep_dds_from_data(count_input=myCounts, target_input=myTargets,
                           experiment_design= ~ batch + Infection, stabilization="vst")


/*
 * Create a DESeq2 data object using previously read count and target data.
 * Differential expression groups indicated by "Time" and "Infection" columns of target data.
 * Takes into account a batch effect column of target data.
 * Apply a variance stabilizing transformation to the data. TMM normalization applied.
 * Collapse technical replicates based on the "replicate" column of target data.
 */
dds <- prep_dds_from_data(count_input=myCounts, target_input=myTargets,
                           experiment_design= ~ batch + Time + Infection,
                           collapseReps=TRUE,
                           rep_field_vector="replicate",
                           stabilization="vst")

 }
}
\seealso{
\code{\link{prep_counts}}, \code{\link{prep_targets}}, \code{\link{init_cutoffs}}
}
\keyword{dds}
\keyword{design}
\keyword{normalization}
\keyword{replicates}
