% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{plot_mds}
\alias{plot_mds}
\title{Visualize multi-dimensional scaled data for all samples, with group-wise metadata incorporated as colors and shapes.}
\usage{
plot_mds(filename = "mds_plot.pdf", color_var, shape_var = "none",
  showConf = TRUE, theme = 1, customLabels = FALSE,
  returnData = FALSE)
}
\arguments{
\item{filename}{Filename for output plot.  Valid extensions are ".pdf" and ".png".
File generation for plot file can be turned off using set_output_mode("screen").
Output will be written to the /MDS/standard/ directory.}

\item{color_var}{The group from target data that should be indicated by color.
Any column of metadata can be used, regardless of experimental design.}

\item{shape_var}{The group from target data that should be indicated by shape.
Any column of metadata can be used, regardless of experimental design. (Optional). Default="none".}

\item{showConf}{Boolean.  Draw an ellipsis representing the 95 percent confidence interval around each group. Default: TRUE}

\item{theme}{Theme for the layout and color scheme for the MDS plot.  Valid selections are integers between 1-6.}

\item{customLabels}{If customLabels is set to TRUE, the user will be prompted to provide a custom label for each label.}

\item{returnData}{If this value is true, this function will return a sample distance matrix. Default: FALSE}
}
\value{
If returnData is true, this function will return a matrix containing sample distances computed to create the MDS plot.
}
\description{
This function performs multi-dimensional scaling (MDS) on data to visualize levels of similarity between individual samples.
Colors and shape variables can be specified according to available metadata, making it possible to identify patterns in the data
based on groups.  For instance, by coloring data points based on "Infected/Non-infected" groups, and drawing data point shapes based on time
point, it is possible to view the differences between infected and non-infected samples across multiple time points.
}
\examples{
\dontrun{

#These examples assume "Time" and "Infection" columns exist in target metadata.

#Make a MDS plot showing all samples, colored based on time point.
plot_mds(filename="mds_plot.pdf", color_var="Time", shape_var="none",
          theme=1, returnData=FALSE)

#Make a MDS plot, colored based on time point with shapes based on infection.
plot_mds(filename="mds_plot.pdf", color_var="Time", shape_var="Infection",
          theme=2, returnData=FALSE)

}
}
\seealso{
\code{\link{plot_mds_hulls}}
}
\keyword{distance}
\keyword{mds}
\keyword{visualization}
