% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init_cutoffs}
\alias{init_cutoffs}
\title{Initialize cutoff values for significance and fold-change filtering.}
\usage{
init_cutoffs(p_signif = 0.05, lfc_cut = 1)
}
\arguments{
\item{p_signif}{P-value cutoff for determining DE genes. Default: 0.05}

\item{lfc_cut}{Log2 fold-change cutoff. Default: 1}
}
\value{
This function does not return a value.
}
\description{
This function initializes the p-value cutoffs and log2foldChange values for most visualizations,
filtering, and aggregation steps of this package. Significant differentially expressed genes will
be initially determined based on the provided p-value cutoff and filtering, when appropriate, will
generally be based on the provided log fold-change cutoff initialized by this function.
}
\examples{
\dontrun{

init_cutoffs(p_signif=0.01, lfc_cut=1.5)

}
}
\keyword{cutoff}
\keyword{filter}
\keyword{fold-change}
\keyword{p-value}
\keyword{significance}
\keyword{threshold}
