% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEEVD.R
\name{mse}
\alias{mse}
\title{Calculate Mean Square Error( MSE) by using Extreme value distributions}
\usage{
mse(kernel, type)
}
\arguments{
\item{kernel}{type of kernel which is to be used}

\item{type}{mention distribution of vector.If exponential distribution then use \code{"Exp"}.
If use gamma distribution then type \code{"Gamma"}.If Gumbel distribution is used with scale=1, then use \code{"Gumbel"}. If Weibull distribution then use \code{"Weibull"}. If use Weibull distribution with scale = 1 then use \code{"Weibull"}.
If use Frechet distribution with scale=1 and shape=1 then use \code{"Frechet"}.}
}
\value{
Mean Squared Error (MSE)
}
\description{
This function calculates the mean squared error (MSE) by using user specified kernel. But distribution of vector should be Exponential, Gamma, Gumbel, Frechet or Weibull. Any other choice of distribution will result \code{NaN}. This function is simillar to function \code{mse} in \pkg{DELTD}, but here more distributions are available for distribution vector.
}
\examples{
y <- rexp(100, 1)
xx <- seq(min(y) + 0.05, max(y), length = 500)
h <- 2
gr <- Gumbel(x = xx, y = y, k = 200, h = h)
mse(kernel = gr, type = "Exp")
## if distribution is other than mentioned \\code{type} is used then NaN will be produced.
\dontrun{
mse(kernel = gr, type ="Beta")
}
}
\references{
\itemize{
\item Salha, R. B., El Shekh Ahmed, H. I., & Alhoubi, I. M. 2014. Hazard Rate Function Estimation Using Weibull Kernel. \emph{Open Journal of Statistics} \strong{4} (08), 650-661.
\item Khan, J. A., & Akbar, A. 2021. Density Estimation Using Gumbel Kernel Estimator. \emph{Open Journal of Statistics} \strong{11} (2), 319-328.
}
}
\author{
Javaria Ahmad Khan, Atif Akbar
}
