% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rossler.sim.R
\name{rossler.sim}
\alias{rossler.sim}
\title{Simulates time-series data from the Rossler system}
\usage{
rossler.sim(
  a = 0.2,
  b = 0.2,
  c = 5.7,
  s = 0,
  x0 = rnorm(1),
  y0 = rnorm(1),
  z0 = rnorm(1),
  time = seq(0, 100, 0.01),
  n.start = 50
)
}
\arguments{
\item{a}{a non-negative integer denoting the value of parameter \code{a} (Default 0.2).}

\item{b}{a non-negative integer denoting the value of parameter \code{b} (Default 0.2).}

\item{c}{a non-negative integer denoting the value of parameter \code{c} (Default 5.7).}

\item{s}{a non-negative integer denoting the variance value of the error term. If \eqn{s=0} gives the standard deterministic map (Default 0).}

\item{x0}{a non-negative integer denoting the initial condition of x-coordinate (Default random number from the normal distribution).}

\item{y0}{a non-negative integer denoting the initial condition of y-coordinate (Default random number from the normal distribution).}

\item{z0}{a non-negative integer denoting the initial condition of z-coordinate (Default random number from the normal distribution).}

\item{time}{a numeric vector denoting the time-lapse and the time-step (Default time-lapse equal to 10000 with a time-step of 0.01 seconds)}

\item{n.start}{a non-negative integer denoting the number of observations that will be discarded to ensure that the values are in the attractor (Default 50).}
}
\value{
A time-series data object generated from the Rossler system with or without an additive measurement noise term. This dataset could be useful for researchers interested in the field of chaotic dynamic systems and non-linear time series analysis and professors (and students) who teach (learn) courses related to those topics.
}
\description{
This function simulates time-series data from the Rossler system considering the parameter set selected by the user. The initial condition is a random number from the normal distribution with mean equal to 0 and variance equal to 1. Some initial conditions may lead to an unstable system that will tend to infinity.
}
\note{
This function provides also noisy time-series data from the deterministic rossler system adding an additive measurement noise term if \eqn{s>0}. We have added to each time-series data a normal multinomial error term denoted by \eqn{{\varepsilon _t} \sim N\left( {0,s} \right)} with different variance values (\eqn{s}). In this sense we have considered it appropriate to add a measurement noise term because most real-world observed time-series data are usually noise-contaminated signals, characterised by an erratic and persistent volatility in certain periods and there is almost always a source of noise linked to measurement errors in real-world datasets. It has been implemented the classical Runge–Kutta method (RK4) in order to generate time-series data from continuous-time dynamical system as the Rossler system.
}
\examples{
## set.seed(34)
## Simulates time-series data from the deterministic rossler system
## with a chaotic behaviour.
ts <- rossler.sim(a=0.2, b=0.2, c=5.7, s=0, time=seq(0,100,0.1))
##
## Simulates time-series data from the deterministic rossler system
## with a non-chaotic behaviour.
ts <- rossler.sim(a=0.1, b=0.1, c=7, s=0, time=seq(0,100,0.1))
}
\references{
Rössler, O. 1976 An equation for continuous chaos. Physics Letters A 57(5):397-398.
}
\author{
Julio E. Sandubete, Lorenzo Escot
}
