% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbDisconnect}
\alias{dbDisconnect}
\title{Disconnect (close) a connection}
\usage{
dbDisconnect(conn, ...)
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{...}{Other parameters passed on to methods.}
}
\value{
a logical vector of length 1, indicating success or failure.
}
\description{
This closes the connection, discards all pending work, and frees
resources (e.g., memory, sockets).
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")
dbDisconnect(con)
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbExecute}},
  \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbSendStatement}}
}

