% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBResult.R
\name{dbBind}
\alias{dbBind}
\title{Bind values to a parameterised/prepared statement}
\usage{
dbBind(res, params, ...)
}
\arguments{
\item{res}{An object inheriting from \code{\linkS4class{DBIResult}}.}

\item{params}{A list of bindings}

\item{...}{Other arguments passed on to methods.}
}
\description{
The \code{\link{dbSendQuery}} function can be called with queries
that contain placeholders for values. This function binds these placeholders
to actual values, and is intended to be called on the result of
\code{\link{dbSendQuery}} before calling \code{\link{dbFetch}}.
}
\details{
Parametrised or prepared statements are executed as follows:

\enumerate{
  \item Call \code{\link{dbSendQuery}} with a query that contains placeholders,
    store the returned \code{\linkS4class{DBIResult}} object in a variable.
    Currently, the syntax for the placeholders is backend-specific,
    e.g., \code{?}, \code{$}, \code{$name} and \code{:name}.
    Mixing placeholders (in particular, named and unnamed ones) is not
    recommended.
  \item Call \code{\link{dbBind}} on the \code{DBIResult} object with a list
    that specifies actual values for the placeholders.  The list must be
    named or unnamed, depending on the kind of placeholders used.
    Named values are matched to named paramters, unnamed values
    are matched by position.
  \item Call \code{\link{dbFetch}} on the same \code{DBIResult} object.
  \item Repeat 2. and 3. as necessary.
  \item Close the result set via \code{\link{dbClearResult}}.
}
}
\examples{
\dontrun{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "iris", iris)
iris_result <- dbSendQuery(con, "SELECT * FROM iris WHERE [Petal.Width] > ?")
dbBind(iris_result, list(2.3))
dbFetch(iris_result)
dbBind(iris_result, list(3))
dbFetch(iris_result)

dbClearResult(iris_result)
dbDisconnect(con)
}
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{SQL}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}}
}

