% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBERlibR.R
\name{independent_samples}
\alias{independent_samples}
\title{Independent Samples Data Analysis}
\usage{
independent_samples(treat_csv_data, ctrl_csv_data, m_cutoff = 0.15)
}
\arguments{
\item{treat_csv_data}{This function requires a csv file with treatment group
data. Its name (e.g., "data_treat_post.csv") can be passed as an argument.
Make sure to set the folder with the data file(s) as the working directory.}

\item{ctrl_csv_data}{This function requires a csv file with control group
data. Its name (e.g., "data_ctrl_post.csv") can be passed as an argument.
Make sure to set the folder with the data file(s) as the working directory.}

\item{m_cutoff}{This package will treat skipped answers as incorrect.
However, too many skipped answers may skew the results of the data analysis.
User can can provide a cutoff for the proportion of skipped answers.
For example, if the user enters 0.1, students who skipped more than
10 percent of the answers will be excluded from the data analysis to prevent
skewed results. The default of 0.15 is commonly applied as a rule of thumb.}
}
\value{
This function returns a \code{tibble()} including the following
information:
\itemize{
 \item \code{n_students_deleted}: Number of students deleted from the data
 for analysis based on the percentage obtained via the argument of m_cutoff
 \item \code{descriptive_statistics}: Descriptive statistics
 \item \code{boxplots}: Boxplots - visual presentation of the descriptive
 statistics
 \item \code{shapiro_wilk_test}: Shapiro-Wilk test results to determine
 normality
 \item \code{normal_qq_plot}: The normal q-q plot to visually inspect the
 normality
 \item \code{independent_samples_t_test_equal}: Results of the independent
 samples t-test with equal variances assumed
 \item \code{independent_samples_t_test_unequal}: Results of the independent
 samples t-test with unequal variances assumed
 \item \code{mann_whitney_u_test}: Results of the Mann-Whitney U test
}
}
\description{
This function automatically cleans the datasets (e.g., converting missing
values to "0), binds treatment-control group datasets, check assumptions,
and then runs the Independent Samples T-test (parametric) and Mann–Whitney U
test (nonparametric) to help you examine the difference between the groups.
R scripts and their outputs are as follows (just pay attention to the outputs
since the codes are automatically run back-end by the function).
}
\examples{
# Run the following codes directly in the console panel. The plots
# generated through the link above may be displaced depending on the screen
# resolution.
independent_samples(treat_csv_data =
         system.file("extdata", "data_treat_post.csv", package = "DBERlibR"),
         ctrl_csv_data =
         system.file("extdata", "data_ctrl_post.csv", package = "DBERlibR"),
         m_cutoff = 0.15)

}
