% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBCV_function.r
\name{dbcv_index}
\alias{dbcv_index}
\title{Function that calculates the original Density-Based Clustering Validation index (DBCV) of clustering results between -1 and +1}
\usage{
dbcv_index(data, partition, noiseLabel = -1)
}
\arguments{
\item{data}{input clustering results}

\item{partition}{labels of the clustering}

\item{noiseLabel}{the code of the noise cluster points, -1 by default}
}
\value{
a real value containing the DBCV coefficient in the [-1;+1] interval
}
\description{
Function that calculates the original Density-Based Clustering Validation index (DBCV) of clustering results between -1 and +1
}
\examples{

 n = 300; noise = 0.05;
 seed = 1782;
 theta <- seq(0, pi, length.out = n / 2)
 x1 <- cos(theta) + rnorm(n / 2, sd = noise)
 y1 <- sin(theta) + rnorm(n / 2, sd = noise)
 x2 <- cos(theta + pi) + rnorm(n / 2, sd = noise)
 y2 <- sin(theta + pi) + rnorm(n / 2, sd = noise)
 X <- rbind(cbind(x1, y1), cbind(x2, y2))
 y <- c(rep(0, n / 2), rep(1, n / 2))

cat("dbcv_index(X, y) = ", dbcv_index(X, y), "\n", sep="")

}
