% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_profile.R
\name{model_profile}
\alias{model_profile}
\alias{variable_profile}
\alias{single_variable}
\title{Dataset Level Variable Profile as Partial Dependence or Accumulated Local Dependence Explanations}
\usage{
model_profile(
  explainer,
  variables = NULL,
  N = 100,
  ...,
  groups = NULL,
  k = NULL,
  center = TRUE,
  type = "partial"
)

variable_profile(
  explainer,
  variables = NULL,
  N = 100,
  ...,
  groups = NULL,
  k = NULL,
  center = TRUE,
  type = "partial"
)

single_variable(explainer, variable, type = "pdp", ...)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the \code{explain} function}

\item{variables}{character - names of variables to be explained}

\item{N}{number of observations used for calculation of aggregated profiles. By default \code{100}. Use \code{NULL} to use all observations.}

\item{...}{other parameters that will be passed to \code{ingredients::aggregate_profiles}}

\item{groups}{a variable name that will be used for grouping.
By default \code{NULL} which means that no groups shall be calculated}

\item{k}{number of clusters for the hclust function (for clustered profiles)}

\item{center}{shall profiles be centered before clustering}

\item{type}{the type of variable profile. Either \code{partial}, \code{conditional} or \code{accumulated}.}

\item{variable}{deprecated, use variables instead}
}
\value{
An object of the class \code{model_profile}.
It's a data frame with calculated average model responses.
}
\description{
This function calculates explanations on a dataset level set that explore model response as a function of selected variables.
The explanations can be calulated as Partial Dependence Profile or  Accumulated Local Dependence Profile.
Find information how to use this function here: \url{https://pbiecek.github.io/ema/partialDependenceProfiles.html}.
The \code{variable_profile} function is a copy of \code{model_profile}.
}
\details{
Underneath this function calls the \code{\link[ingredients]{partial_dependence}} or
\code{\link[ingredients]{accumulated_dependence}} functions from the \code{ingredients} package.
}
\examples{
titanic_glm_model <- glm(survived~., data = titanic_imputed, family = "binomial")
explainer_glm <- explain(titanic_glm_model, data = titanic_imputed)
model_profile_glm_fare <- model_profile(explainer_glm, "fare")
plot(model_profile_glm_fare)

 \donttest{
library("ranger")
titanic_ranger_model <- ranger(survived~., data = titanic_imputed, num.trees = 50,
                               probability = TRUE)
explainer_ranger  <- explain(titanic_ranger_model, data = titanic_imputed)
model_profile_ranger <- model_profile(explainer_ranger)
plot(model_profile_ranger, geom = "profiles")

model_profile_ranger_1 <- model_profile(explainer_ranger, type = "partial",
                                        variables = c("age", "fare"))
plot(model_profile_ranger_1 , variables = c("age", "fare"), geom = "points")

model_profile_ranger_2  <- model_profile(explainer_ranger, type = "partial", k = 3)
plot(model_profile_ranger_2 , geom = "profiles")

model_profile_ranger_3  <- model_profile(explainer_ranger, type = "partial", groups = "gender")
plot(model_profile_ranger_3 , geom = "profiles")

model_profile_ranger_4  <- model_profile(explainer_ranger, type = "accumulated")
plot(model_profile_ranger_4 , geom = "profiles")

# Multiple profiles
model_profile_ranger_fare <- model_profile(explainer_ranger, "fare")
plot(model_profile_ranger_fare, model_profile_glm_fare)
 }

}
\references{
Explanatory Model Analysis. Explore, Explain, and Examine Predictive Models. \url{https://pbiecek.github.io/ema/}
}
