% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_variable.R
\name{single_variable}
\alias{single_variable}
\title{Marginal Response for a Single Variable}
\usage{
single_variable(explainer, variable, type = "pdp", trans = I, ...)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'explain' function}

\item{variable}{character - name of a single variable}

\item{type}{character - type of the response to be calculated.
Currently following options are implemented: 'pdp' for Partial Dependency and 'ale' for Accumulated Local Effects}

\item{trans}{function - a transformation/link function that shall be applied to raw model predictions}

\item{...}{other parameters}
}
\value{
An object of the class 'single_variable_explainer'.
It's a data frame with calculated average response.
}
\description{
Calculates the average model response as a function of a single selected variable.
Use the 'type' parameter to select the type of marginal response to be calculated.
Currently we have Partial Dependency and Accumulated Local Effects implemented.
Current implementation uses the 'pdp' package (Brandon M. Greenwell (2017).
pdp: An R Package for Constructing Partial Dependence Plots. The R Journal, 9(1), 421--436.)
and 'ALEPlot' (Dan Apley (2017). ALEPlot: Accumulated Local Effects Plots and Partial Dependence Plots.)
}
\examples{
library("breakDown")
logit <- function(x) exp(x)/(1+exp(x))

HR_glm_model <- glm(left~., data = breakDown::HR_data, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR_data)
expl_glm <- single_variable(explainer_glm, "satisfaction_level", "pdp", trans=logit)
expl_glm

\dontrun{
library("randomForest")
HR_rf_model <- randomForest(left~., data = breakDown::HR_data, ntree = 100)
explainer_rf  <- explain(HR_rf_model, data = HR_data)
expl_rf  <- single_variable(explainer_rf, variable =  "satisfaction_level", type = "pdp")
expl_rf
}

}
