% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_asr_node_states.R
\name{add_asr_node_states}
\alias{add_asr_node_states}
\title{Fits a model of ancestral state reconstruction of island presence}
\usage{
add_asr_node_states(
  phylod,
  asr_method,
  tie_preference = "island",
  earliest_col = FALSE
)
}
\arguments{
\item{phylod}{A `phylo4d` object from the package `phylobase` containing
phylogenetic and endemicity data for each species.}

\item{asr_method}{A character string, either "parsimony" or "mk" determines
whether a maximum parsimony or continuous-time markov model reconstructs the
ancestral states at each node. See documentation in
`castor::asr_maximum_parsimony` or `castor::asr_mk` in `castor` R package
for details on the methods used.}

\item{tie_preference}{Character string, either "island" or "mainland" to
choose the most probable state at each node using the `max.col()` function.
When a node has island presence and absence equally probable we need to
decide whether that species should be considered on the island. To consider
it on the island use `ties.method = "last"` in the `max.col()` function, if
you consider it not on the island use `ties.method = "first"`. Default is
"island".}

\item{earliest_col}{A boolean to determine whether to take the colonisation
time as the most probable time (FALSE) or the earliest possible colonisation
time (TRUE), where the probability of a species being on the island is
non-zero. Default is FALSE.}
}
\value{
An object of `phylo4d` class with tip and node data
}
\description{
Fits a model of ancestral state reconstruction of island presence
}
