% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_check_format.R
\name{is_simulation_outputs}
\alias{is_simulation_outputs}
\title{Measures if the input is a valid collection of simulation
outputs.}
\usage{
is_simulation_outputs(simulation_outputs)
}
\arguments{
\item{simulation_outputs}{A list with matrices and vectors of simulation
produced by DAISIE_sim functions.}
}
\value{
TRUE if the input is a valid collection of simulation
outputs.
}
\description{
Measures if the input is a valid collection of simulation
outputs.
}
\examples{
testthat::expect_false(DAISIE:::is_simulation_outputs("nonsense"))

simulation_outputs <- DAISIE_sim_cr(
  time = 2,
  M = 1000,
  pars = c(2, 1, 20, 0.0001, 1),
  replicates = 1,
  plot_sims = FALSE
 )
testthat::expect_true(DAISIE:::is_simulation_outputs(simulation_outputs))
}
\author{
Richel J.C Bilderbeek, Pedro Neves
}
\keyword{internal}
