% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAFOT_function.R
\name{SCalculation}
\alias{SCalculation}
\title{The effctive number of tree calculation}
\usage{
SCalculation(sP, sQ, Tree, t)
}
\arguments{
\item{sP}{a vector. The component-wise variance of 1st group}

\item{sQ}{a vector. The component-wise variance of 2nd group}

\item{Tree}{A phylo class. Phylogenetic tree}

\item{t}{a numeric. The proportion of sample from 1st group.}
}
\value{
\code{SCalculation} returns a value for effctive number of tree.
}
\description{
\code{SCalculation} is used to calculate the effctive number of tree.
}
\details{
This function is used to calculate the effctive number of tree.
}
\examples{
library(ape)
Tree=rtree(100)
alphaP=c(rep(1,length(Tree$tip.label)),rep(0,Tree$Nnode))
alphaQ=c(rep(1,length(Tree$tip.label)),rep(0,Tree$Nnode))
DataPQ<-DataGenerating(100,100,alphaP,alphaQ,1000)
sdP=apply(DataPQ$P,1,sd)
sdQ=apply(DataPQ$Q,1,sd)
SCalculation(sdP,sdQ,Tree,100/(100+100))

##must install metagenomeFeatures from Bioconductor before trying this example
\donttest{
library(metagenomeFeatures)
gg85 <- get_gg13.8_85MgDb()
gamma_16S <- mgDb_select(gg85, type = "all", keys = "Gammaproteobacteria", keytype = "Class")
Tree=gamma_16S$tree
Tree$tip.label<-1:length(Tree$tip.label)
alphaP=c(rep(1,length(Tree$tip.label)),rep(1,Tree$Nnode))
alphaQ=c(rep(1,length(Tree$tip.label)),rep(1,Tree$Nnode))
alphaQ[1]=alphaQ[1]+1
DataPQ<-DataGenerating(100,100,alphaP,alphaQ,1000)
sdP=apply(DataPQ$P,1,sd)
sdQ=apply(DataPQ$Q,1,sd)
SCalculation(sdP,sdQ,Tree,100/(100+100))
}

}
\seealso{
\code{\link{DAFOT}}
}
\author{
Shulei Wang
}
