% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D3partitionR.R
\name{D3partitionR}
\alias{D3partitionR}
\title{D3partitionR}
\usage{
D3partitionR(random = F, data = NULL, type = "circleTreeMap",
  tooltipOptions = list(showAbsolutePercent = T, showRelativePercent = T),
  width = NULL, height = NULL, elementId = NULL, title = list(text =
  NULL, fontSize = "auto"), legend = list(type = "categorical", color = NULL))
}
\arguments{
\item{random}{generates a radom CircleTreeMap, default to FALSE.}

\item{data}{The inputs data, it should be in one of the following form:\cr 
-a dataframe with two columns, the first one being the paths (and named path) and the second one the value of the paths.\cr 
-a list of two lists with the same properties.}

\item{type}{type of plots, to be among circleTreeMap, partitionChart, treeMap, sunburst. Defaut to circleTreeMap.}

\item{tooltipOptions}{list of options for the tooltip:\cr 
-showAbsolutePercent: show the absolute percent from the beginning. Defaut to true.\cr 
-showRelativePercent: show the percent of remaining from the previous step. Defaut to true.}

\item{width}{width of the element.}

\item{height}{height of the element.}

\item{elementId}{Id of the element, default to null.}

\item{title}{options for the title:\cr 
-text: text to be displayed\cr 
-fontSize: fontSize (ex: "24px")}

\item{legend}{List of options for the legend:\cr 
-type, the legend can be either categorical or sequential. \cr 
      When setted to categorical, every different step has a different color.\cr 
      When setted to sequential, the steps with a color provided are used as a reference. The further a steps from these reference, the darker.\cr 
-color, Coerce the colors of some steps. Notice: only the colors provided in these are going to be shown in the legend.}
}
\description{
This function generates the CircleTreeMap from your data or from random data
}
\examples{

#Base bubbleTreeMap with random data
D3partitionR(TRUE)

#sunburst with categorical colors and some coerced legend and color
D3partitionR(TRUE,type="sunburst",
tooltipOptions = list(showAbsolutePercent=FALSE,showRelativePercent=FALSE),
legend=list(type="categorical",color=list("step A"="#0BA","step B"="#AA1","step C"="#ECC")))
}

