\name{random.walk.tests}
\alias{random.walk.tests}
\title{
Random Walk Tests
}
\description{
Perfoms random walk tests of Doganaksoy et al. (2006) to evaluate the randomess of an RNG. It runs Random Walk Excursion, Random Walk Expansion, and Random Walk Height tests. 
}
\usage{
random.walk.tests(x, B = 64, Excursion = TRUE, Expansion = TRUE, 
                  Height = TRUE, alpha = 0.05)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
    a matrix that includes random data in base-2 format. See details for further information.
}
  \item{B}{
    the length of words (B-bit). See Details section.
}
  \item{Excursion}{
    if \code{TRUE}, Random Walk Excursion test is applied.
}
  \item{Expansion}{
    if \code{TRUE}, Random Walk Expansion test is applied.
}
  \item{Height}{
    if \code{TRUE}, Random Walk Height test is applied.
}
  \item{alpha}{
    a predetermined value of type-I error with the default value of 0.05.
}
}
\details{
Argument \code{x} should be entered as a matrix of bits of dimension \eqn{B}x\eqn{k}, where \eqn{k} is the number of words (integers) generated by the RNG of interest.

If Excursion is TRUE, B takes 16, 32, 64, 128, and 256. If Expansion is TRUE, B takes 64, 128, 256, 512, and 1024. If Height is TRUE, B takes 32, 64, and 128. Because thoretical cumulative distribution functions for the other word lengths, \code{random.walk.tests()} performs tests under given bit settings. If one of the tests is not applied, all the results related with that test in output are set to -1.
}
\value{

\item{AD.statistic.Excursion}{
    value of test statistic of Anderson-Darling goodness-of-fit test conducted after application of Random Walk Excursion procedure.
}
\item{KS.statistic.Excursion}{
    value of test statistic of Kolmogorov-Smirnov goodness-of-fit test conducted after application of Random Walk Excursion procedure.
}
\item{CS.statistic.Excursion}{
    value of test statistic of Chi-Square goodness-of-fit test conducted after application of Random Walk Excursion procedure.
}
\item{AD.pvalue.Excursion}{
    p-value of Anderson-Darling goodness-of-fit test conducted after application of Random Walk Excursion procedure.
}
\item{KS.pvalue.Excursion}{
    p-value of Kolmogorov-Smirnov goodness-of-fit test conducted after application of Random Walk Excursion procedure.
}
\item{CS.pvalue.Excursion}{
    p-value of Chi-Square goodness-of-fit test conducted after application of Random Walk Excursion procedure.
}
\item{AD.result.Excursion}{
    returns 0 if H0 is rejected and 1 otherwise in Anderson-Darling goodness-of-fit test conducted after application of Random Walk Excursion procedure.
}
\item{KS.result.Excursion}{
    returns 0 if H0 is rejected and 1 otherwise in Kolmogorov-Smirnov goodness-of-fit test conducted after application of Random Walk Excursion procedure.
}
\item{CS.result.Excursion}{
    returns 0 if H0 is rejected and 1 otherwise in Chi-Square goodness-of-fit test conducted after application of Random Walk Excursion procedure.
}

\item{AD.statistic.Expansion}{
    value of test statistic of Anderson-Darling goodness-of-fit test conducted after application of Random Walk Expansion procedure.
}
\item{KS.statistic.Expansion}{
    value of test statistic of Kolmogorov-Smirnov goodness-of-fit test conducted after application of Random Walk Expansion procedure.
}
\item{CS.statistic.Expansion}{
    value of test statistic of Chi-Square goodness-of-fit test conducted after application of Random Walk Expansion procedure.
}
\item{AD.pvalue.Expansion}{
    p-value of Anderson-Darling goodness-of-fit test conducted after application of Random Walk Expansion procedure.
}
\item{KS.pvalue.Expansion}{
    p-value of Kolmogorov-Smirnov goodness-of-fit test conducted after application of Random Walk Expansion procedure.
}
\item{CS.pvalue.Expansion}{
    p-value of Chi-Square goodness-of-fit test conducted after application of Random Walk Expansion procedure.
}
\item{AD.result.Expansion}{
    returns 0 if H0 is rejected and 1 otherwise in Anderson-Darling goodness-of-fit test conducted after application of Random Walk Expansion procedure.
}
\item{KS.result.Expansion}{
    returns 0 if H0 is rejected and 1 otherwise in Kolmogorov-Smirnov goodness-of-fit test conducted after application of Random Walk Expansion procedure.
}
\item{CS.result.Expansion}{
    returns 0 if H0 is rejected and 1 otherwise in Chi-Square goodness-of-fit test conducted after application of Random Walk Expansion procedure.
}

\item{AD.statistic.Height}{
    value of test statistic of Anderson-Darling goodness-of-fit test conducted after application of Random Walk Height procedure.
}
\item{KS.statistic.Height}{
    value of test statistic of Kolmogorov-Smirnov goodness-of-fit test conducted after application of Random Walk Height procedure.
}
\item{CS.statistic.Height}{
    value of test statistic of Chi-Square goodness-of-fit test conducted after application of Random Walk Height procedure.
}
\item{AD.pvalue.Height}{
    p-value of Anderson-Darling goodness-of-fit test conducted after application of Random Walk Height procedure.
}
\item{KS.pvalue.Height}{
    p-value of Kolmogorov-Smirnov goodness-of-fit test conducted after application of Random Walk Height procedure.
}
\item{CS.pvalue.Height}{
    p-value of Chi-Square goodness-of-fit test conducted after application of Random Walk Height procedure.
}
\item{AD.result.Height}{
    returns 0 if H0 is rejected and 1 otherwise in Anderson-Darling goodness-of-fit test conducted after application of Random Walk Height procedure.
}
\item{KS.result.Height}{
    returns 0 if H0 is rejected and 1 otherwise in Kolmogorov-Smirnov goodness-of-fit test conducted after application of Random Walk Height procedure.
}
\item{CS.result.Height}{
    returns 0 if H0 is rejected and 1 otherwise in Chi-Square goodness-of-fit test conducted after application of Random Walk Height procedure.
}
}
\references{
Doganaksoy, A., Calik, C., Sulak, F., Turan, M.S., New randomness tests using random walk, In: National Cryptology Symposium II, (2006), Ankara, Turkey.
}
\author{
Haydar Demirhan

Maintainer: Haydar Demirhan <haydarde@hacettepe.edu.tr>
}

\examples{

RNGkind(kind = "Super-Duper")
B=64                        # Bit length is 64.
k=500                       # Generate 500 integers.
dat=round(runif(k,0,(2^B-1)))
x=sfsmisc::digitsBase(dat, base= 2, B) #Convert to base 2
alpha = 0.05
test=random.walk.tests(x, B, Excursion = TRUE, Expansion = TRUE, Height = TRUE, alpha)
print(test)

}
\keyword{ ~Anderson-Darling }
\keyword{ ~Kolmogorov-Smirnov }
\keyword{ ~Chi-Square }
\keyword{ ~nonparametric }
\keyword{ ~goodness-of-fit test }
\keyword{ ~randomness test }
