% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blobify.R
\name{blobify}
\alias{blobify}
\title{Denoise a black and white image to only core features}
\usage{
blobify(image, size)
}
\arguments{
\item{image}{An image.}

\item{size}{An odd number, the starting size of the kernel for morphology, minimum of 3 starting size.}
}
\description{
This takes a black and white image, preferrably the image produced by an otsu transformation, and gets rid of all extrenuous features. Many long skinny features and random clumps of features will be erased, leaving only the larger core features of an image.
}
\details{
Using morphology functions \url{https://en.wikipedia.org/wiki/Mathematical_morphology} to get rid of unwanted noise and features.
With this package the features to eliminate will mostly be random weeds and bushy leaves. The specific functions being use are opening \url{https://en.wikipedia.org/wiki/Opening_(morphology)} and closing \url{https://en.wikipedia.org/wiki/Closing_(morphology)}.
The first step of the function is opening to start to get rid of smaller features. It then closes the holes created by opening the image and repeats this process several times with bigger and bigger kernels.
This allows more important featrures to remain while insignificant ones are erased. There is a minimum starting size of 2, because when doing the first closing process it needs to be at least a 1 pixel kernel.
}
\examples{
\donttest{final_blob <- blobify(image, size)}

}
