% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--analysis_tools--DHS_methods--classification_function.R
\name{classifyQuantileFlagRegression}
\alias{classifyQuantileFlagRegression}
\title{Classify FlagRegression  with rolling Quantile info}
\usage{
classifyQuantileFlagRegression(
  DF,
  Pval = 0.3,
  model_sig_column = lmreg_sig,
  WW_column = pastKavg.wwlog10
)
}
\arguments{
\item{DF}{dataframe that contains results of buildRegressionEstimateTable and makeQuantileColumns}

\item{Pval}{threshold needed for flag_ntile_Pval to flag}

\item{model_sig_column}{column name of significance of linear model that generated 
the percent change}

\item{WW_column}{column containing ww data}
}
\value{
DF with three extra columns 
cdc_flag: when the CDC method labels as 'major increase'
flag_ntile: when the cdc flag and its in the top quantile
flag_ntile_Pval: when the flag ntile and the regression slope is less
than Pval
}
\description{
Create wastewater flags based on the CDC classification defined in 
classifyRegressionAnalysis and the quantile rank of the date.
}
\examples{
data(Example_data, package = "Covid19Wastewater")
Example_data$modeled_percentchange = 0
Example_data$lmreg_sig = .01
Example_data$pastKavg.wwlog10 = 5
Example_data$ntile = 8
classifyQuantileFlagRegression(Example_data)
}
