#' CovTools : A Collection of Geometric and Statistical Tools for Covariance Analysis
#'
#' Covariance is of universal prevalence across various disciplines within statistics.
#' The \pkg{CovTools} aims at providing a rich collection of geometric and inferential tools
#' for convenient analysis of covariance structures, topics including distance measures,
#' mean covariance estimator, covariance hypothesis test for one-sample and two-sample cases,
#' and covariance estimation.
#'
#' @docType package
#' @name CovTools-package
#' @import shapes
#' @importFrom stats cov qnorm rnorm
#' @importFrom mvtnorm rmvnorm
#' @importFrom expm expm sqrtm logm
#' @importFrom geigen geigen
#' @importFrom Rcpp evalCpp
#' @useDynLib CovTools
NULL



