\name{datfc}
\alias{datfc}
\docType{data}
\title{ Simulated Data, Mixed}
\description{This data is simulated. The covariates, X, and the treatment, T, are all generated by simulating from a multivariate normal distribution and then some variables are dichotomized to get binary variables with a certain dependence structure. The code generating the data is \cr
\cr
\code{library(mvtBinaryEP)}\cr
\code{set.seed(9327529)}\cr
\code{n<-500}\cr
\code{eta<-mvrnorm(n,rep(0,2),diag(1,2,2))}\cr
\code{R<-diag(1,9,9)}\cr
\code{R[c(1,3,8),9]<-R[9,c(1,3,8)]<-0.27} \cr
\code{R[2,9]<-R[9,2]<-0.33}\cr
\code{R[4,9]<-R[9,4]<-0.18}\cr
\code{R[5,9]<-R[9,5]<-0.23}\cr
\code{R[2,5]<-R[5,2]<-0.71}\cr
\code{R[3,4]<-R[4,3]<-0.50}\cr
\code{seed<-runif(1,10000,100000000)}\cr
\code{ep0<-ep(mu=c(rep(0.5,9)), R=R, nRep=n, seed=seed)}\cr
\code{rS<-ep0$isd$rootS}\cr
\code{rn<-ranMVN2(nRep =n, rootS=rS,seed=seed)}\cr
\code{X<-matrix(c(-rn[,1],ep0$y[,2],-rn[,3:4],ep0$y[,5:6],rn[,7],ep0$y[,8]),ncol=8)}\cr
\code{T<-ep0$y[,9]}\cr
\code{y0<-4+2*X[,1]+3*X[,4]+5*X[,5]+2*X[,6]+eta[,1]}\cr
\code{y1<-2+2*X[,1]+3*X[,4]+5*X[,5]+2*X[,6]+eta[,2]}\cr
\code{y<-y1*T+y0*(1-T)}\cr
\code{datfc<-data.frame(x1=X[,1],x2=X[,2],x3=X[,3],x4=X[,4],x5=X[,5],x6=X[,6],x7=X[,7],}\cr
\code{x8=X[,8],y0,y1,y,T)}\cr
\code{datfc[,c(2,5,6,8)]<-lapply(datfc[,c(2,5,6,8)],as.factor)}
}
\usage{data(datfc)}
\format{
  A data frame with 500 observations on the following 12 variables.
  \describe{
    \item{\code{x1  }}{a numeric vector}
    \item{\code{x2  }}{a factor with two levels}
    \item{\code{x3  }}{a numeric vector}
    \item{\code{x4  }}{a numeric vector}
    \item{\code{x5  }}{a factor with two levels}
    \item{\code{x6  }}{a factor with two levels}
    \item{\code{x7  }}{a numeric vector}
    \item{\code{x8  }}{a factor with two levels}
    \item{\code{y0  }}{a numeric vector}
    \item{\code{y1  }}{a numeric vector}
    \item{\code{y   }}{a numeric vector}
    \item{\code{T }}{a numeric vector}
  }
}
