% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{surv}
\alias{surv}
\title{Wrapper to built in survival functions}
\usage{
surv(t, distPars, dist)
}
\arguments{
\item{t}{double, time point where the survival is to be evaluated at.}

\item{distPars}{\code{Rcpp::List} with distribution specific slots,
see details.}

\item{dist}{character name of the built-in distribution, see details.}
}
\value{
a double giving the value of the survival function at time point
\code{t} at the parameters' values.
}
\description{
Wrapper to built in survival functions
}
\details{
The function wraps all builtin-survival distributions. User can choose
between the \code{weibull}, \code{gamma}, \code{gengamma}(generalized gamma)
and \code{burr} (Burr type XII distribution). It is the user responsibility
to pass the appropriate list of parameters as follows:
\describe{
\item{weibull}{\code{scale} (the scale) and \code{shape} (the shape)
    parameters.}
\item{burr}{\code{scale} (the scale) and \code{shape1} (the shape1) and
    \code{shape2} (the shape2) parameters.} 
\item{gamma}{ \code{scale} (the scale) and \code{shape} (the shape)
    parameter.}
\item{gengamma}{\code{mu} (location), \code{sigma} (scale) and \code{Q}
    (shape) parameters.}
}
}
\examples{
tt <- 2.5
## weibull

distP <- list(scale = 1.2, shape = 1.16)
alpha <- exp(-log(distP[["scale"]]) / distP[["shape"]])
pweibull(q = tt, scale = alpha, shape = distP[["shape"]],
                      lower.tail = FALSE)
surv(tt, distP, "weibull") ## (almost) same

## gamma
distP <- list(shape = 0.5, rate = 1.0 / 0.7)
pgamma(q = tt, rate = distP[["rate"]], shape = distP[["shape"]],
                    lower.tail = FALSE)
surv(tt, distP, "gamma")  ## (almost) same

## generalized gamma
distP <- list(mu = 0.5, sigma = 0.7, Q = 0.7)
flexsurv::pgengamma(q = tt, mu = distP[["mu"]],
                    sigma = distP[["sigma"]],
                    Q = distP[["Q"]],
                    lower.tail = FALSE)
surv(tt, distP, "gengamma")  ## (almost) same

}
