% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_test_stat.R
\name{find_test_stat}
\alias{find_test_stat}
\title{Calculate Observed Test Statistic}
\usage{
find_test_stat(y, w, test_stat = NULL, fun = NULL)
}
\arguments{
\item{y}{Vector of observed outcomes}

\item{w}{Vector indicating treatment assignments}

\item{test_stat}{Name of built in test statistic function. Provide
"diffmeans" for difference of means, "t" for t test, "paired-t" for paired
t test, and "cohens-d" for cohen's d test (optional)}

\item{fun}{Test statistic function (optional)}
}
\value{
Observed test statistic (numeric)
}
\description{
Finds observed test statistic using treatment and control outcomes
}
\details{
Assignments must be indicated in argument "w" using numeric 1 or 0.

One of either argument "test_stat" or "fun" must be specified.

Argument "fun" must take in two parameters (treated outcomes and
control outcomes) and returns a numeric test statistic value (scalar).
}
\examples{
find_test_stat(sample_data$turn_angle, sample_data$w,
test_stat = c("diffmeans"))

find_test_stat(sample_data$turn_angle, sample_data$w,
 test_stat = c("t"))
}
