% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_fisher_interval.R
\name{create_fisher_interval}
\alias{create_fisher_interval}
\title{Compute Fisher Interval}
\usage{
create_fisher_interval(null_r, alpha = NULL, width = NULL)
}
\arguments{
\item{null_r}{"null_rand" object corresponding to data used for interval}

\item{alpha}{Significance level for Fisher Interval (default = .05
for 95\% confidence)}

\item{width}{Integer indicating the number of values to search for to construct
Fisher Interval. Default value = 10000. (Increasing this argument may result
in increased accuracy of interval.) (Optional)}
}
\value{
Class "fisher_interval" with 4 entries:
\describe{
\item{lower_bound}{Lower bound of Fisher Interval}
\item{upper_bound}{Upper bound of Fisher Interval}
\item{alpha}{Specified significance value}
\item{pvalue_lower}{P-value corresponding to lower bound of interval}
\item{pvalue_upper}{P-value corresponding to upper bound of interval}
\item{range}{Range of effect values tested}
\item{null_r}{Specified "null_rand" object}
}
}
\description{
Computes Fisher (Fidicual) Interval and returns object of
"fisher_interval" class.
}
\details{
Call summary on "fisher_interval" class to retrieve information on the
Fisher Interval. Call plot on "fisher_interval" class for visualization
of Fisher Interval.

Use "create_null_rand" function to produce "null_rand" object for first
argument.

Note: The warning 'Fisher Interval coverage is smaller than specified'
indicates that there are no effect sizes found that match the p-value bounds
for the specified significance level (ie. .025 and .975 for alpha = .05).
In this case, the largest possible interval found under the significance
level alpha will be returned. Check "pvalue_lower" and "pvalue_upper"
parameters to see which p-value bounds are used.
}
\examples{
\donttest{
y = sample_data$turn_angle
w = sample_data$w
n_r = create_null_rand(y,w, sample_matrix, test_stat = c("diffmeans"))
f= create_fisher_interval(n_r)
summary(f)
plot(f)
}

}
\references{
\doi{10.48550/arXiv.2105.03996}
}
