% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBData.R
\name{ran.CBData}
\alias{ran.CBData}
\title{Generate random correlated binary data}
\usage{
ran.CBData(
  sample.sizes,
  p.gen.fun = function(g) 0.3,
  rho.gen.fun = function(g) 0.2,
  pdf.fun = qpower.pdf
)
}
\arguments{
\item{sample.sizes}{a dataset with variables Trt, ClusterSize and Freq giving
the number of clusters to be generated for each Trt/ClusterSize combination.}

\item{p.gen.fun}{a function of one parameter that generates the value of the
first parameter of \code{pdf.fun} (\emph{p}) given the group number.}

\item{rho.gen.fun}{a function of one parameter that generates the value of
the second parameter of \code{pdf.fun} (\emph{rho}) given the group number.}

\item{pdf.fun}{a function of three parameters (\emph{p, rho, n}) giving the
PDF of the number of responses in a cluster given the two parameters
(\emph{p, rho}), and the cluster size (\emph{n}). Functions implementing two
common distributions: the beta-binomial (\code{\link{betabin.pdf}}) and
q-power (\code{\link{qpower.pdf}}) are provided in the package.}
}
\value{
a CBData object with randomly generated number of responses with
sample sizes specified in the call.
}
\description{
\code{ran.mc.CBData} generates a random \code{\link{CBData}} object from a
given two-parameter distribution.
}
\details{
\dfn{p.gen.fun} and \dfn{rho.gen.fun} are functions that generate the
parameter values for each treatment group; \dfn{pdf.fun} is a function
generating the pdf of the number of responses given the two parameters
\dfn{p} and \dfn{rho}, and the cluster size \dfn{n}.

\code{p.gen.fun} and \code{rho.gen.fun} expect the parameter value of 1 to
represent the first group, 2 - the second group, etc.
}
\examples{

set.seed(3486)
ss <- expand.grid(Trt=0:3, ClusterSize=5, Freq=4)
#Trt is converted to a factor
rd <- ran.CBData(ss, p.gen.fun=function(g)0.2+0.1*g)
rd

}
\seealso{
\code{\link{betabin.pdf}} and \code{\link{qpower.pdf}}
}
\author{
Aniko Szabo, aszabo@mcw.edu
}
\keyword{distribution}
