% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.cdtafit}
\alias{summary.cdtafit}
\title{Function to generate a summary  a cdtafit object.}
\usage{
\method{summary}{cdtafit}(object, digits = 3, ...)
}
\arguments{
\item{object}{An object from \link{fit}.}

\item{digits}{An optional positive value to control the number of digits to print when printing numeric values.}

\item{...}{other \link[rstan]{stan} options.}
}
\value{
The posterior mean and 95 percent credible intervals, n_eff, Rhat and WAIC.
}
\description{
Function to generate a summary  a cdtafit object.
}
\examples{

\dontrun{

fit1 <- fit(data=telomerase,
             SID = "ID",
             copula="fgm",
             iter = 400,
             warmup = 100,
             seed=1,
             cores=1)

ss <- summary(fit1)

}
}
\author{
Victoria N Nyaga \email{victoria.nyaga@outlook.com}
}
\references{
{Watanabe S (2010). Asymptotic Equivalence of Bayes Cross Validation and Widely Applicable Information Criterion in Singular
Learning Theory. Journal of Machine Learning Research, 11, 3571-3594.}

{Vehtari A, Gelman A (2014). WAIC and Cross-validation in Stan. Unpublished, pp. 1-14.}
}

