% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{printcopula}
\alias{printcopula}
\title{Print a summary of the fitted model.}
\usage{
printcopula(object, digits = 3, ...)
}
\arguments{
\item{object}{An object from \link{fitcopula}.}

\item{digits}{An optional positive value to control the number of digits to print when printing numeric values.}

\item{...}{other \link[rstan]{stan} options.}
}
\value{
The posterior mean and 95 percent credible intervals, n_eff, Rhat and WAIC.
}
\description{
Print a summary of the fitted model.
}
\examples{

data(telomerase)
\dontrun{
fit <- fitcopula(data=telomerase,
SID = "ID",
copula="fgm",
iter = 400,
warmup = 100,
seed=1,
cores=1)

printcopula(object=fit)

print(fit$model, pars=c('p_i'), digits=4, prob=c(0.025, 0.975))
}
}
\author{
Victoria N Nyaga
}
\references{
{Watanabe S (2010). Asymptotic Equivalence of Bayes Cross Validation and Widely Applicable Information Criterion in Singular
Learning Theory. Journal of Machine Learning Research, 11, 3571-3594.}

{Vehtari A, Gelman A (2014). WAIC and Cross-validation in Stan. Unpublished, pp. 1-14.}
}

